#include <struct.h>
#include <3dengine.h>

#include "dof.h"

long		NumMaterials = 0;
long		NumVerts = 0;
long		NumFaces = 0;
tPOINT*		Verts = NULL;
tPOINT*		Norms = NULL;
DOFFace*	Indices = NULL;
tPOINT2D*	UVs = NULL;
DOFBurst	Burst;


long CreateMaterial(CDirect3D*	pD3D,
					DOFMat*		pMat,
					DOFMatUV*	pMatUV,
					long		BlendMode,
					char*		pName,
					char*		pClass,
					char*		pTextureName)
{
	char str[MAX_MATERIALNAMELEN];
	if (0==strcmp(pName, "") && 0==strcmp(pClass, ""))
		sprintf(str, "Material#%u",pD3D->Materials.MaterialsAmount);
	else
		sprintf(str, "%s::%s",pName, pClass);

	BOOL bTextured = (0!=strcmp(pTextureName, ""));
	if (bTextured)
	{
		long index = pD3D->FindMaterial(
			FIND_MATCH_PRIMTEXTURENAME | FIND_MATCH_ALPHATREAT,
			pTextureName,
			NULL,
			"chrome.bmp",
			NULL,
			0xFFFFFFFF,
			NULL,
			D3DTOP_MODULATE,
			D3DTOP_DISABLE,
			D3DTOP_ADD,
			D3DTOP_DISABLE,
			(BlendMode == 1) ? 1 : 0);
		if (index != -1)
			return index;
	}

	return pD3D->CreateMaterial(
		bTextured ? 1.0f: pMat->ambient[0],
		bTextured ? 1.0f: pMat->ambient[1],
		bTextured ? 1.0f: pMat->ambient[2],
		bTextured ? 1.0f: 1.0f-pMat->ambient[3],
		pMat->shininess,
		80.0f,
		pTextureName,
		NULL,
		"chrome.bmp",
		NULL,
		str,
		TEX_NAMEPATHMATCH_NOCASE | TEX_NAMEPATHMATCH_NAMEONLY,
		D3DTOP_MODULATE,
		D3DTOP_DISABLE,
		D3DTOP_ADD,
		D3DTOP_DISABLE,
		D3DBLEND_SRCALPHA,
		D3DBLEND_INVSRCALPHA,
		BlendMode == 1 ? 1 : 0,
		0x80,
		(BYTE)D3DCMP_GREATEREQUAL,
		0x00000000,
		0x00000000,
		TRUE);
}

void CreateObject(
		tObjectSet* Objects,
		long		Material,
		long*		MaterialsMap,
		long*		EnvMatMap)
{
	if (!Verts || !Indices)
		return;


	tObject* pObj = new tObject;
	sprintf(pObj->ObjectName, "DOF Object");
	pObj->VertTable->Init(NumVerts);
	pObj->FaceTable->Init(NumFaces);
	for (VertCount = 0; VertCount < NumVerts; VertCount++)
	{
		pObj->VertTable->Table[VertCount].X = Verts[VertCount].x;
		pObj->VertTable->Table[VertCount].Y = Verts[VertCount].y;
		pObj->VertTable->Table[VertCount].Z = Verts[VertCount].z;
		if (Norms)
		{
			pObj->VertTable->Table[VertCount].NormalX = Norms[VertCount].x;
			pObj->VertTable->Table[VertCount].NormalY = Norms[VertCount].y;
			pObj->VertTable->Table[VertCount].NormalZ = Norms[VertCount].z;
		}
	}

	for (FaceCount = 0; FaceCount < NumFaces; FaceCount++)
	{
		pObj->FaceTable->Table[FaceCount].I1 = Indices[FaceCount].i2;
		pObj->FaceTable->Table[FaceCount].I2 = Indices[FaceCount].i1;
		pObj->FaceTable->Table[FaceCount].I3 = Indices[FaceCount].i3;
		if (UVs)
		{
			pObj->FaceTable->Table[FaceCount].U1 = UVs[Indices[FaceCount].i2].x;
			pObj->FaceTable->Table[FaceCount].V1 = 1.0f-UVs[Indices[FaceCount].i2].y;
			pObj->FaceTable->Table[FaceCount].U2 = UVs[Indices[FaceCount].i1].x;
			pObj->FaceTable->Table[FaceCount].V2 = 1.0f-UVs[Indices[FaceCount].i1].y;
			pObj->FaceTable->Table[FaceCount].U3 = UVs[Indices[FaceCount].i3].x;
			pObj->FaceTable->Table[FaceCount].V3 = 1.0f-UVs[Indices[FaceCount].i3].y;
		}
		pObj->FaceTable->Table[FaceCount].Material = MaterialsMap[Material];
		if (EnvMatMap[Material] != 1)
			pObj->FaceTable->Table[FaceCount].nRenderFlags = NoBlend;
	}
	
	Objects->AddObject(pObj);
	delete pObj;
	if (Verts)		delete[] Verts;
	if (Norms)		delete[] Norms;
	if (Indices)	delete[] Indices;
	if (UVs)		delete[] UVs;
	if (Burst.burstMtlID)		delete[] Burst.burstMtlID;
	if (Burst.burstStart)		delete[] Burst.burstStart;
	if (Burst.burstVperP)		delete[] Burst.burstVperP;
	if (Burst.burstCount)		delete[] Burst.burstCount;
	Verts				= NULL;
	Norms				= NULL;
	Indices				= NULL;
	UVs					= NULL;
	Burst.burstMtlID	= NULL;
	Burst.burstStart	= NULL;
	Burst.burstVperP	= NULL;
	Burst.burstCount	= NULL;
	Burst.NumBursts = 0;
}


DWORD CALLBACK Import(
		CString           fromfile,
		CWnd*             pwnd,
		tObjectSet*       Objects,
		tUnDataSet*       UnData,
		CDirect3D*        pD3D,
		SYSTEMREQUESTPROC RequestProc,
		HINSTANCE         AppHIns,
		HINSTANCE         DllHIns)
{
	DOFChunk chunk;
	CFile InFile;
	if (!InFile.Open(fromfile, CFile::modeRead))
		return ShowFailMessage(pwnd, "Error opening file",
			"Invalid attributes, or access violation", MB_ICONEXCLAMATION);

	long	readed = 0;
	long	length = InFile.GetLength();

	long*	MaterialsMap = NULL;
	long*	EnvMatMap = NULL;
	long	CurrentMaterial = -1;
	char	MaterialName[MAX_MATERIALNAMELEN],
			MaterialClass[MAX_MATERIALNAMELEN],
			TextureName[MAX_MATERIALNAMELEN];
	DOFMat	Mat;
	DOFMatUV	MatUV;
	long	Trans, Blend;
	short	amount;
	tObjectSet CurrentObjects;

	long	CurrentObject = -1;

	while(readed < length)
	{//read the file
		readed += chunk.ReadChunk(&InFile);
		if (chunk.ID == *(DWORD*)("DOF1"))
			;
		else
		if (chunk.ID == *(DWORD*)("MATS"))
		{//materials section;
			readed += InFile.Read(&NumMaterials, 4);
			MaterialsMap = new long[NumMaterials];
			EnvMatMap = new long[NumMaterials];
			CurrentMaterial = -1;
		}
		else
		if (chunk.ID == *(DWORD*)("MAT0"))
			;//materials header;
		else
		if (chunk.ID == *(DWORD*)("MHDR"))
		{//materials header;
			if (-1 != CurrentMaterial)
				MaterialsMap[CurrentMaterial] = CreateMaterial(
					pD3D,
					&Mat,
					&MatUV,
					Blend,
					MaterialName,
					MaterialClass,
					TextureName);

			CurrentMaterial++;
			memset(MaterialName, 0, MAX_MATERIALNAMELEN);
			memset(MaterialClass, 0, MAX_MATERIALNAMELEN);
			memset(TextureName, 0, MAX_MATERIALNAMELEN);
			readed += InFile.Read(&amount, 2);
			readed += InFile.Read(MaterialName, amount);
			readed += InFile.Read(&amount, 2);
			readed += InFile.Read(MaterialClass, amount);
			Trans = 0;
			Blend = 0;
			EnvMatMap[CurrentMaterial] = 1;//env map ON
		}
		else
		if (chunk.ID == *(DWORD*)("MCOL"))
			readed += InFile.Read(&Mat, sizeof(DOFMat));
		else
		if (chunk.ID == *(DWORD*)("MUVW"))
			readed += InFile.Read(&MatUV, sizeof(DOFMatUV));
		else
		if (chunk.ID == *(DWORD*)("MTRA"))
		{
			readed += InFile.Read(&Trans, 4);
			readed += InFile.Read(&Blend, 4);
		}
		else
		if (chunk.ID == *(DWORD*)("MCFL"))
		{
			readed += InFile.Read(&EnvMatMap[CurrentMaterial], 4);
		}
		else
		if (chunk.ID == *(DWORD*)("MTEX"))
		{
			long am;
			readed += InFile.Read(&am, 4);
			for (;am > 0; am--)
			{
				readed += InFile.Read(&amount, 2);
				readed += InFile.Read(TextureName, amount);
			}
		}
		else
		if (chunk.ID == *(DWORD*)("MEND"))
		{//materials end;
			if (-1 != CurrentMaterial)
				MaterialsMap[CurrentMaterial] = CreateMaterial(
					pD3D,
					&Mat,
					&MatUV,
					Blend,
					MaterialName,
					MaterialClass,
					TextureName);
			readed -= 4;
			InFile.Seek(-4, CFile::current);
		}
		else
		if (chunk.ID == *(DWORD*)("GEOB"))//geometry section
		{
			readed+=InFile.Read(&Trans,4);//amount of objects
			CurrentObject = -1;
		}
		else
		if (chunk.ID == *(DWORD*)("GOB1"))//starting new object
		{
			if (-1 != CurrentObject)
				CreateObject(
					&CurrentObjects,
					CurrentMaterial,
					MaterialsMap,
					EnvMatMap);

			CurrentObject++;
			CurrentMaterial = 0;
			Verts	= NULL;
			Norms	= NULL;
			Indices	= NULL;
			UVs		= NULL;
		}
		else
		if (chunk.ID == *(DWORD*)("GHDR"))//object's header
		{
			readed += InFile.Read(&CurrentMaterial, 4);//int flags; (none defined yet)
			readed += InFile.Read(&CurrentMaterial, 4);//int paintFlags; (none defined yet)
			readed += InFile.Read(&CurrentMaterial, 4);//int materialRef; (the material index)
		}
		else
		if (chunk.ID == *(DWORD*)("INDI"))
		{
			readed += InFile.Read(&NumFaces, 4);
			NumFaces = NumFaces/3;
			Indices = new DOFFace[NumFaces];
			readed += InFile.Read(Indices, sizeof(DOFFace)*NumFaces);
		}
		else
		if (chunk.ID == *(DWORD*)("VERT"))
		{
			readed += InFile.Read(&NumVerts, 4);
			Verts = new tPOINT[NumVerts];
			readed += InFile.Read(Verts, sizeof(tPOINT)*NumVerts);
		}
		else
		if (chunk.ID == *(DWORD*)("NORM"))
		{
			long am;
			readed += InFile.Read(&am, 4);
			if (am == NumVerts)
			{
				Norms = new tPOINT[am];
				readed += InFile.Read(Norms, sizeof(tPOINT)*am);
			}
			else
			{
				InFile.Seek(sizeof(tPOINT)*am, CFile::current);
				readed += sizeof(tPOINT)*am;
			}
		}
		else
		if (chunk.ID == *(DWORD*)("TVER"))
		{
			long am;
			readed += InFile.Read(&am, 4);
			if (am == NumVerts)
			{
				UVs = new tPOINT2D[am];
				readed += InFile.Read(UVs, sizeof(tPOINT2D)*am);
			}
			else
			{
				InFile.Seek(sizeof(tPOINT2D)*am, CFile::current);
				readed += sizeof(tPOINT2D)*am;
			}
		}
		else
		if (chunk.ID == *(DWORD*)("BRST"))
		{
			readed += InFile.Read(&Burst.NumBursts, 4);
			Burst.burstMtlID = new long[Burst.NumBursts];
			Burst.burstStart = new long[Burst.NumBursts];
			Burst.burstVperP = new long[Burst.NumBursts];
			Burst.burstCount = new long[Burst.NumBursts];

			readed += InFile.Read(Burst.burstStart, 4*Burst.NumBursts);
			readed += InFile.Read(Burst.burstCount, 4*Burst.NumBursts);
			readed += InFile.Read(Burst.burstMtlID, 4*Burst.NumBursts);
			readed += InFile.Read(Burst.burstVperP, 4*Burst.NumBursts);
		}
		else
		if (chunk.ID == *(DWORD*)("GEND"))
		{//object end;
			if (-1 != CurrentObject)
				CreateObject(
					&CurrentObjects,
					CurrentMaterial,
					MaterialsMap,
					EnvMatMap);
			readed -= 4;
			InFile.Seek(-4, CFile::current);
		}
		else
			readed += chunk.SkipChunk(&InFile);
	}//read the file

	if (MaterialsMap) delete[] MaterialsMap;
  if (EnvMatMap)    delete[] EnvMatMap;

	if (CurrentObjects.ObjAmount > 1)
	{
		CurrentObjects.SelectAll();
		CurrentObjects.CopyObjects(FALSE, TRUE, FALSE, FALSE, TRUE);
		if (CurrentObjects.ObjAmount != 1)
			return 0;
	}
	tObject* pObj = CurrentObjects.RemoveObjectFromSet(0);
	if (!pObj) return 0;

	fromfile.MakeLower();
	if (fromfile.ReverseFind('\\') > 0)
		fromfile = fromfile.Right(fromfile.GetLength()-fromfile.ReverseFind('\\')-1);
	strcpy(pObj->ObjectName, fromfile);
	pObj->UnSelect();

	Objects->AddObject(pObj);
	delete pObj;

	return 1;
}